/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Set;
import net.sourceforge.plantuml.skin.PragmaKey;
import net.sourceforge.plantuml.warning.Warning;
import net.sourceforge.plantuml.warning.WarningHandler;

public class Pragma
implements WarningHandler {
    private final EnumMap<PragmaKey, String> values = new EnumMap(PragmaKey.class);
    private final Set<Warning> warnings = new LinkedHashSet<Warning>();

    private Pragma() {
    }

    public static Pragma createEmpty() {
        return new Pragma();
    }

    public void define(String keyName, String value) {
        PragmaKey key = PragmaKey.lazyFrom(keyName);
        if (key != null) {
            this.values.put(key, value);
        }
    }

    public boolean isDefine(PragmaKey key) {
        return this.values.containsKey((Object)key);
    }

    public void undefine(PragmaKey key) {
        this.values.remove((Object)key);
    }

    public String getValue(PragmaKey key) {
        return this.values.get((Object)key);
    }

    public boolean isTrue(PragmaKey key) {
        String value = this.getValue(key);
        return "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
    }

    public boolean isFalse(PragmaKey key) {
        String value = this.getValue(key);
        return "false".equalsIgnoreCase(value) || "off".equalsIgnoreCase(value);
    }

    public static boolean legacyReplaceBackslashNByNewline() {
        return true;
    }

    @Override
    public void addWarning(Warning warning) {
        this.warnings.add(warning);
    }

    @Override
    public Collection<Warning> getWarnings() {
        return this.warnings;
    }
}

