/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.tim.Trie;

public class TrieImpl
implements Trie {
    private final Map<Character, TrieImpl> brothers = new HashMap<Character, TrieImpl>();

    @Override
    public void add(String s) {
        if (s.indexOf(0) != -1) {
            throw new IllegalArgumentException();
        }
        TrieImpl.addInternal(this, s + "\u0000");
    }

    private static void addInternal(TrieImpl current, String s) {
        if (s.length() == 0) {
            throw new UnsupportedOperationException();
        }
        while (s.length() > 0) {
            Character added = Character.valueOf(s.charAt(0));
            TrieImpl child = current.getOrCreate(added);
            s = s.substring(1);
            current = child;
        }
    }

    public boolean remove(String s) {
        return TrieImpl.removeInternal(this, s + "\u0000");
    }

    private static boolean removeInternal(TrieImpl current, String s) {
        if (s.length() <= 1) {
            throw new UnsupportedOperationException();
        }
        while (s.length() > 0) {
            Character first = Character.valueOf(s.charAt(0));
            TrieImpl child = current.brothers.get(first);
            if (child == null) {
                return false;
            }
            if ((s = s.substring(1)).length() == 1) {
                assert (s.charAt(0) == '\u0000');
                return child.brothers.remove(Character.valueOf('\u0000')) != null;
            }
            current = child;
        }
        throw new IllegalStateException();
    }

    private TrieImpl getOrCreate(Character added) {
        TrieImpl result = this.brothers.get(added);
        if (result == null) {
            result = new TrieImpl();
            this.brothers.put(added, result);
        }
        return result;
    }

    @Override
    public String getLonguestMatchStartingIn(String s, int pos) {
        return TrieImpl.getLonguestMatchStartingIn(this, s, pos);
    }

    private static String getLonguestMatchStartingIn(TrieImpl current, String s, int pos) {
        StringBuilder result = new StringBuilder();
        while (current != null) {
            if (s.length() == pos) {
                if (current.brothers.containsKey(Character.valueOf('\u0000'))) {
                    return result.toString();
                }
                return "";
            }
            TrieImpl child = current.brothers.get(Character.valueOf(s.charAt(pos)));
            if (child == null || child.brothers.size() == 0) {
                if (current.brothers.containsKey(Character.valueOf('\u0000'))) {
                    return result.toString();
                }
                return "";
            }
            result.append(s.charAt(pos));
            current = child;
            ++pos;
        }
        return "";
    }
}

