/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;

public class Skeleton2 {
    private final List<Entry> entries = new ArrayList<Entry>();
    private static final double sizeX = 8.0;

    public void add(int level, double y) {
        this.entries.add(new Entry(level, y));
    }

    public void draw(UGraphic ug) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry en = this.entries.get(i);
            en.drawHline(ug);
            Entry up = this.getMotherOrSister(i);
            en.drawVline(ug, up == null ? 0.0 : up.ypos);
        }
    }

    private Entry getMotherOrSister(int idx) {
        int currentLevel = this.entries.get(idx).level;
        for (int i = idx - 1; i >= 0; --i) {
            int otherLevel = this.entries.get(i).level;
            if (otherLevel != currentLevel && otherLevel != currentLevel - 1) continue;
            return this.entries.get(i);
        }
        return null;
    }

    private static double getXStartForLevel(int level) {
        return (double)level * 8.0;
    }

    public double getXEndForLevel(int level) {
        return Skeleton2.getXStartForLevel(level) + 8.0;
    }

    static class Entry {
        private final int level;
        private final double ypos;

        Entry(int level, double y) {
            this.level = level;
            this.ypos = y;
        }

        void drawHline(UGraphic ug) {
            double xpos = Skeleton2.getXStartForLevel(this.level);
            ug.apply(new UTranslate(xpos + 8.0 - 1.0, this.ypos - 1.0)).draw(URectangle.build(2.0, 2.0));
            ug.apply(new UTranslate(xpos, this.ypos)).draw(ULine.hline(8.0));
        }

        public void drawVline(UGraphic ug, double lastY) {
            double xpos = Skeleton2.getXStartForLevel(this.level);
            ug.apply(new UTranslate(xpos, lastY)).draw(ULine.vline(this.ypos - lastY));
        }
    }
}

